/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.common.util;

import com.ibm.hsc.cim.exceptions.HSCCIMException;
import com.ibm.hsc.common.util.Trace;
import com.ibm.hsc.common.util.VersionComparator;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.snia.wbemcfg.GlobalConfig;

public class ParseResponse {
    int statusByte = -1;
    int resourceType = -1;
    int resourceOpcode = -1;
    int asyncStatusOpcode = -1;
    int ttyOpcode = -1;
    int ttyStatus = -1;
    DataInputStream responseData = null;
    int release_version = -1;
    private Properties configValuesPropObj = null;
    private static Properties configValuesPropObj2 = null;
    private static Properties configValuesPropObj3 = null;
    public static final String CEC_NAME = "CEC_NAME";
    public static final String CEC_TYPE = "CEC_TYPE";
    public static final String SERIAL_NO = "SERIAL_NO";
    public static final String CEC_STATE = "CEC_STATE";
    public static final String CAPABILITY = "CAPABILITY";
    public static final String MODE = "MODE";
    public static final String SERVICE_MODE = "SERVICE_MODE";
    public static final String CEC_OP_PANEL_LINE = "CEC_OP_PANEL_LINE";
    public static final String NVRAM_SIZE = "NVRAM_SIZE";
    public static final String NVRAM_DATA = "NVRAM_DATA";
    public static final String NUM_PROCESSORS = "NUM_PROCESSORS";
    public static final String NUM_IO_DRAWERS = "NUM_IO_DRAWERS";
    public static final String MEMORY = "MEMORY";
    public static final String POWER_SETTING = "POWER_SETTING";
    public static final String POWER_POLICY = "POWER_POLICY";
    public static final String EVENT_NOTIFICATION = "EVENT_NOTIFICATION";
    public static final String HANDLER_MASK = "HANDLER_MASK";
    public static final String SEQUENCE_NO = "SEQUENCE_NO";
    public static final String EVENT_TYPE = "EVENT_TYPE";
    public static final String PARAMETER_LIST = "PARAMETER_LIST";
    public static final String HANDLER_NO = "HANDLER_NO";
    public static final String CEC_STATUS = "CEC_STATUS";
    public static final String BYTE_OFFSET = "BYTE_OFFSET";
    public static final String N_BYTES = "N_BYTES";
    public static final String POWER_MODE_VALUE = "POWER_MODE_VALUE";
    public static final String MODE_SETTING = "MODE_SETTING";
    public static final String YEAR = "YEAR";
    public static final String MONTH = "MONTH";
    public static final String DAY = "DAY";
    public static final String HOUR = "HOUR";
    public static final String MINUTE = "MINUTE";
    public static final String SECONDS = "SECONDS";
    public static final String LOCK = "LOCK";
    public static final String OWNER = "OWNER";
    public static final String NUM_LPAR_SLOTS = "NUM_LPAR_SLOTS";
    public static final String ALL_LPAR_STATE = "ALL_LPAR_STATE";
    public static final String LPAR_ID = "LPAR_ID";
    public static final String LPAR_NAME = "LPAR_NAME";
    public static final String BOOT_MODE = "BOOT_MODE";
    public static final String LPAR_OP_PANEL_LINE = "LPAR_OP_PANEL_LINE";
    public static final String SERVICE_AUTHORITY = "SERVICE_AUTHORITY";
    public static final String DEFINITION_STATE = "DEFINITION_STATE";
    public static final String RESET_TYPE = "RESET_TYPE";
    public static final String PROC_ID = "PROC_ID";
    public static final String PROC_STATE = "PROC_STATE";
    public static final String LOCATION_CODE = "LOCATION_CODE";
    public static final String ALL_PROC_ASSIGNMENT = "ALL_PROC_ASSIGNMENT";
    public static final String ALL_PROC_STATE = "ALL_PROC_STATE";
    public static final String NUM_PROCS = "NUM_PROCS";
    public static final String PROC_STATUS = "PROC_STATUS";
    public static final String MEMORY_INSTALLED = "MEMORY_INSTALLED";
    public static final String POSSIBLE_MEMORY = "POSSIBLE_MEMORY";
    public static final String TOT_MEMORY_REQUESTED = "TOT_MEMORY_REQUESTED";
    public static final String TOT_ALLOC_MEMORY = "TOT_ALLOC_MEMORY";
    public static final String HYPER_ALLOC_MEMORY = "HYPER_ALLOC_MEMORY";
    public static final String PAGE_TABLE_ALLOC_MEMORY = "PAGE_TABLE_ALLOC_MEMORY";
    public static final String FAILED_MEMORY = "FAILED_MEMORY";
    public static final String TOT_AVAILABLE_MEMORY = "TOT_AVAILABLE_MEMORY";
    public static final String REGION_SIZE = "REGION_SIZE";
    public static final String PAGE_TABLE_RATIO = "PAGE_TABLE_RATIO";
    public static final String LOGICAL_DRAWER_ID = "LOGICAL_DRAWER_ID";
    public static final String DRAWER_ID = "DRAWER_ID";
    public static final String DRAWER_IDS = "DRAWER_IDS";
    public static final String SLOT_NO = "SLOT_NO";
    public static final String DRAWER_CLASS = "DRAWER_CLASS";
    public static final String DRAWER_LOC_CODE = "DRAWER_LOC_CODE";
    public static final String NUM_SLOTS = "NUM_SLOTS";
    public static final String SLOT_INFO = "SLOT_INFO";
    public static final String SLOT_INFORMATION = "SLOT_INFORMATION";
    public static final String IO_STATE = "IO_STATE";
    public static final String IO_STATUS = "IO_STATUS";
    public static final String DEVICE_ID = "DEVICE_ID";
    public static final String VENDOR_ID = "VENDOR_ID";
    public static final String SLOT_LOC_CODE = "SLOT_LOC_CODE";
    public static final String PCI_CLAS_CODE = "PCI_CLASS_CODE";
    public static final String PCI_CLASS = "PCI_CLASS";
    public static final String PCI_BUS_NO = "PCI_BUS_NO";
    public static final String STATUS_BYTE = "STATUS_BYTE";
    public static final String ASYNC_STATUS_OPCODE = "ASYNC_STATUS_OPCODE";
    public static final String LPAR_STATE = "LPAR_STATE";
    public static final String LPAR_MIN_MEM_SIZE = "LPAR_MIN_MEM_SIZE";
    public static final String PROC_CHANGE = "PROC_CHANGE";
    public static final String MEMORY_CHANGE = "MEMORY_CHANGE";
    public static final String IO_DRAWER_CHANGE = "IO_DRAWER_CHANGE";
    public static final String BOOT_ERROR = "BOOT_ERROR";
    public static final String SESSION_NO = "SESSION_NO";
    public static final String LIST_SESSION_NUMBERS = "LIST_SESSION_NUMBERS";
    public static final String XON_VALUE = "XON_VALUE";
    public static final String OPEN_STATUS_CODE = "OPEN_STATUS_CODE";
    public static final String COUNT = "COUNT";
    public static final String TTY_OPCODE = "TTY_OPCODE";
    public static final String TTY_DATA = "TTY_DATA";
    public static final String NO_OUTSTANDING_PKTS = "NO_OUTSTANDING_PKTS";
    public static final String OP_PANEL_WIDTH = "OP_PANEL_WIDTH";
    public static final String OP_PANEL_NLINES = "OP_PANEL_NLINES";
    public static final String RESOURCE = "RESOURCE";
    public static final String BROADCAST_EVENT = "BROADCAST_EVENT";
    public static final String LPAR_PROFILE_ID = "LPAR_PROFILE_ID";
    public static final String SYSTEM_PROFILE_ID = "SYSTEM_PROFILE_ID";
    public static final String ERROR_TYPE = "ERROR_TYPE";
    public static final String SLOT_ID = "SLOT_ID";
    public static final String NUMBER_INFO_SLOTS = "NUMBER_INFO_SLOTS";
    public static final String CURRENT_HSC_SLOT = "CURRENT_HSC_SLOT";
    public static final String LEN_INFO = "LEN_INFO";
    public static final String HSC_INFO = "HSC_INFO";
    public static final String POLL_FREQUENCY = "POLL_FREQUENCY";
    public static final String REPORT_TIMEOUTS_VALUE = "REPORT_TIMEOUTS_VALUE";
    public static final String HSC_CONNECTION_STATUS = "HSC_CONNECTION_STAUS";
    public static final String HSC_NAME = "HSC_NAME";
    public static final String MTU_SIZE = "MTU_SIZE";
    public static final String BROADCAST_EVENT_SIZE = "BROADCAST_EVENT_SIZE";
    public static final String FORMAT_TYPE = "FORMAT_TYPE";
    public static final String VERSION = "VERSION";
    public static final String NUMBER_OF_VERSIONS_SUPPORTED = "NUMBER_OF_VERSIONS_SUPPORTED";
    public static final String VERSION_LIST = "VERSION_LIST";
    public static final String FORCE_FLAG = "FORCE_FLAG";
    public static final String MULTI_LINES_DATA = "MULTI_LINES_DATA";
    public static final String SP_LOG_ENTRY = "SP_LOG_ENTRY";
    public static final String LOG_INDEX_ID = "LOG_INDEX_ID";
    public static final String LEN_NEXT_4FIELDS = "LEN_NEXT_4FIELDS";
    public static final String LEN_EACH_SLOT_INFO = "LEN_EACH_SLOT_INFO";
    public static final String DRC_INDEX = "DRC_INDEX";
    public static final String DEV_NUM = "DEV_NUM";
    public static final String NUM_OF_ADAPTERS = "NUM_OF_ADAPTERS";
    public static final String LEN_EACH_DEV_ENTRY = "LEN_EACH_DEV_ENTRY";
    public static final String DEV_LIST = "DEV_LIST";
    public static final String LEN_NEXT_2FIELDS = "LEN_NEXT_2FIELDS";
    public static final String LEN_NEXT_9FIELDS = "LEN_NEXT_9FIELDS";
    public static final String MAX_WINS_SUPPORTED = "MAX_WINS_SUPPORTED";
    public static final String MAX_NUMBER_LPARS = "MAX_NUMBER_LPARS";
    public static final String WIN_GRANULARITY = "WIN_GRANULARITY";
    public static final String NUM_WINS_ACTIVE = "NUM_WINS_ACTIVE";
    public static final String NUM_LPARS_ACTIVE = "NUM_LPARS_ACTIVE";
    public static final String SMA_TYPE = "SMA_TYPE";
    public static final String SMA_STATUS = "SMA_STATUS";
    public static final String SMA_STATE = "SMA_STATE";
    public static final String SMA_PHY_LOC = "SMA_PHY_LOC";
    public static final String SMA_PROC_LOC = "SMA_PROC_LOC";
    public static final String LPAR_INFO_LIST = "LPAR_INFO_LIST";
    public static final String NUM_WINS_USING = "NUM_WINS_USING";
    public static final String LPARS_DEFINED = "LPARS_DEFINED";
    public static final String NUM_AFFINITY_GROUPS = "NUM_AFFINITY_GROUPS";
    public static final String SMA_AFFINITY_GROUPS = "SMA_AFFINITY_GROUPS";
    public static final String ONOFF_PROC_CHANGE = "ONOFF_PROC_CHANGE";
    public static final String ONOFF_MEMORY_CHANGE = "ONOFF_MEMORY_CHANGE";
    public static final String SMA_PRESENT_MASK = "SMA_PRESENT_MASK";
    public static final String SMA_FUNC_MASK = "SMA_FUNC_MASK";
    public static final String SMA_LINK_INFO = "SMA_LINK_INFO";
    public static final String MAC0_CONFIG_A = "MAC0_CONFIG_A";
    public static final String MAC0_CONFIG_B = "MAC0_CONFIG_B";
    public static final String MAC0_CONFIG_STATUS = "MAC0_CONFIG_STATUS";
    public static final String MAC1_CONFIG_A = "MAC1_CONFIG_A";
    public static final String MAC1_CONFIG_B = "MAC1_CONFIG_B";
    public static final String MAC1_CONFIG_STATUS = "MAC1_CONFIG_STATUS";
    public static final String LINK_STATUS = "LINK_STATUS";
    public static final String LINK_PHY_ID = "LINK_PHY_ID";
    public static final String BASE_SUPPORT = "BASE_SUPPORT";
    public static final String MAX_WINS_REQ = "MAX_WINS_REQ";
    public static final String MIN_WINS_REQ = "MIN_WINS_REQ";
    public static final String NUM_GROUPS = "NUM_GROUPS";
    public static final String AFFINITY_TYPE = "AFFINITY_TYPE";
    public static final String GROUP_LIST = "GROUP_LIST";
    public static final String TOTAL_MEMORY = "TOTAL_MEMORY";
    public static final String PROC_GROUP_LIST = "PROC_GROUP_LIST";
    public static final String PROC_GROUP_LOCATION = "PROC_GROUP_LOCATION";
    public static final String SLOT_DEFINITION = "SLOT_DEFINITION";
    public static final String TYPE_VALUE = "TYPE_VALUE";
    public static final String RMO_TYPE = "RMO_TYPE";
    public static final String ALL_PROC_STATUS = "ALL_PROC_STATUS";
    public static final String START_ENTRY = "START_ENTRY";
    public static final String NUM_ENTRIES = "NUM_ENTRIES";
    public static final String TOTAL_ENTRIES = "TOTAL_ENTRIES";
    public static final String LMB_INFO = "LMB_INFO";
    public static final String MEM_GROUP_LOCATION = "MEM_GROUP_LOCATION";
    public static final String ALL_LPAR_DEFINITION_FIELDS = "ALL_LPAR_DEFINITION_FIELDS";
    public static final String NUM_LPARS = "NUM_LPARS";
    public static final String SLOT_LIST = "SLOT_LIST";
    public static final String LPAR_LIST = "LPAR_LIST";
    public static final String PROC_LIST = "PROC_LIST";
    public static final String NODE_TYPE = "NODE_TYPE";
    public static final String CUOD_CAPABILITIES = "CUOD_CAPABILITIES";
    public static final String ENTRY_CHECK = "ENTRY_CHECK";
    public static final String CCIN = "CCIN";
    public static final String UNIQUE_ID = "UNIQUE_ID";
    public static final String SYSTEM_SERIAL_NO = "SYSTEM_SERIAL_NO";
    public static final String TYPE_NUMBER = "TYPE_NUMBER";
    public static final String PROCESSORS_ACTIVATED = "PROCESSORS_ACTIVATED";
    public static final String AMOUNT_MEMORY = "AMOUNT_MEMORY";
    public static final String CUOD_ACTIVATION_CODE = "CUOD_ACTIVATION_CODE";
    public static final String CUOD_CTA_VALUE = "CUOD_CTA_VALUE";
    public static final String NUM_MEM_PERMANENT = "NUM_MEM_PERMANENT";
    public static final String NUM_MEM_IMMEDIATE = "NUM_MEM_IMMEDIATE";
    public static final String NUM_MEM_NOT_PERMANENT = "NUM_MEM_NOT_PERMANENT";
    public static final String MEM_ACTIVE_IMM_STATE = "MEM_ACTIVE_IMM_STATE";
    public static final String MEM_ACTIVE_IMM_HOURS_REM = "MEM_ACTIVE_IMM_HOURS_REM";
    public static final String MEMORY_ACTIVATED = "MEMORY_ACTIVATED";
    public static final String NUM_PROCS_PERMANENT = "NUM_PROCS_PERMANENT";
    public static final String NUM_PROCS_IMMEDIATE = "NUM_PROCS_IMMEDIATE";
    public static final String NUM_PROCS_NOT_PERMANENT = "NUM_PROCS_NOT_PERMANENT";
    public static final String PROC_ACTIVATE_IMM_STATE = "PROC_ACTIVATE_IMM_STATE";
    public static final String PROC_ACTIVATE_IMM_HOURS_REM = "PROC_ACTIVATE_IMM_HOURS_REM";
    public static final String RESOURCE_ID = "RESOURCE_ID";
    public static final String SEQ_NO = "SEQ_NO";
    public static final String MEM_ACTIVATE_IMM_STATE = "MEM_ACTIVATE_IMM_STATE";
    public static final String HACKING_EVENT = "HACKING_EVENT";
    public static final String DECRYPTION_RETURN_CODE = "DECRYPTION_RETURN_CODE";
    public static final String MESSAGE_TYPE = "MESSAGE_TYPE";
    public static final String MESSAGE_DESTINATION = "MESSAGE_DESTINATION";
    public static final String MESSAGE_ID = "MESSAGE_ID";
    public static final String NUM_PARAMS = "NUM_PARAMS";
    public static final String PARAMETERS_LIST = "PARAMETERS_LIST";
    public static final String LED_TYPE = "LED_TYPE";
    public static final String LED_INDEX = "LED_INDEX";
    public static final String LED_STATE = "LED_STATE";
    public static final String FILE_ID = "FILE_ID";
    public static final String FILE_SIZE = "FILE_SIZE";
    public static final String DATA_SIZE = "DATA_SIZE";
    public static final String BYTES_READ = "BYTES_READ";
    public static final String BYTES_WRITE = "BYTES_WRITE";
    public static final String FLAGS = "FLAGS";
    public static final String FILE_DISPOSITION = "FILE_DISPOSITION";
    public static final String HMC_MANAGED_UCODE = "HMC_MANAGED_UCODE";
    public static final String FRAME_NUMBER = "FRAME_NUMBER";
    public static final String BPA_TYPE = "BPA_TYPE";
    public static final String SRC_LPAR_ID = "SRC_LPAR_ID";
    public static final String DST_LPAR_ID = "DST_LPAR_ID";
    public static final String RESOURCE_ELEMENT_IDS = "RESOURCE_ELEMENT_IDS";
    public static final String RESOURCE_TYPE = "RESOURCE_TYPE";
    public static final String NUM_RESOURCES = "NUM_RESOURCES";
    public static final String GET_CUOD_ACTIVATE_IMMED_INCREMENT = "GET_CUOD_ACTIVATE_IMMED_INCREMENT";
    public static final String PROCESSOR_INCREMENT = "PROCESSOR_INCREMENT";
    public static final String MEMORY_INCREMENT = "MEMORY_INCREMENT";
    public static final String TOTAL_PROC_DAYS_PREV_ORDERED = "TOTAL_PROC_DAYS_PREV_ORDERED";
    public static final String ONOFF_PROCS_IN_USE = "ONOFF_PROCS_IN_USE";
    public static final String ONOFF_PROCS_PENDING = "ONOFF_PROCS_PENDING";
    public static final String ONOFF_PROCS_INCREMENT = "ONOFF_PROCS_INCREMENT";
    public static final String ONOFF_PROCS_GARDED = "ONOFF_PROCS_GARDED";
    public static final String ONOFF_STATE = "ONOFF_STATE";
    public static final String ONOFF_HOURS_REMAINING = "ONOFF_HOURS_REMAINING";
    public static final String ONOFF_DAYS_REMAINING = "ONOFF_DAYS_REMAINING";
    public static final String ONOFF_RESOURCE_ID = "ONOFF_RESOURCE_ID";
    public static final String ONOFF_CCIN_ID = "ONOFF_CCIN_ID";
    public static final String ONOFF_SEQUENCE_NUM = "ONOFF_SEQUENCE_NUM";
    public static final String ONOFF_ENTRY_CHECK = "ONOFF_ENTRY_CHECK";
    public static final String ONOFF_SERIAL_NUM = "ONOFF_SERIAL_NUM";
    public static final String ONOFF_UNIQUE_ID = "ONOFF_UNIQUE_ID";
    public static final String ONOFF_SYSTEM_SERIAL_NUM = "ONOFF_SYSTEM_SERIAL_NUM";
    public static final String ONOFF_SYSTEM_TYPE = "ONOFF_SYSTEM_TYPE";
    public static final String NUM_ONOFF_PROCS_TO_MANAGE = "NUM_ONOFF_PROCS_TO_MANAGE ";
    public static final boolean DEBUG_ON = false;

    public ParseResponse() {
    }

    public ParseResponse(byte[] byArray) throws IOException {
        try {
            this.release_version = VersionComparator.CSPVersionValue("V2.0");
            if (this.release_version == -1) {
                throw new HSCCIMException("1397");
            }
            this.parseOpcodes(byArray);
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
        }
    }

    public ParseResponse(byte[] byArray, String string) throws IOException {
        try {
            this.release_version = VersionComparator.CSPVersionValue(string);
            if (this.release_version == -1) {
                throw new HSCCIMException("1397");
            }
            this.parseOpcodes(byArray);
        }
        catch (HSCCIMException hSCCIMException) {
            hSCCIMException.printStackTrace();
        }
    }

    void parseOpcodes(byte[] byArray) throws IOException {
        this.configValuesPropObj = null;
        if (this.release_version == 1000 || this.release_version == 2000) {
            this.configValuesPropObj = configValuesPropObj2;
        }
        if (this.release_version == 3000 || this.release_version == 4000) {
            this.configValuesPropObj = configValuesPropObj3;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        this.responseData = new DataInputStream(byteArrayInputStream);
        this.responseData.mark(1);
        this.responseData.skipBytes(4);
        this.statusByte = this.responseData.readUnsignedByte();
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("\n StatusByte: " + this.statusByte);
        }
        if (this.statusByte != 8) {
            this.responseData.skipBytes(1);
            this.resourceType = this.responseData.readUnsignedByte();
            this.resourceOpcode = this.responseData.readUnsignedByte();
            if (GlobalConfig.debugLevel((int)7) > 0) {
                System.out.println("\n RT : " + this.resourceType);
                System.out.println("\n Ropcode : " + this.resourceOpcode);
            }
        }
        if (this.statusByte == 8) {
            this.asyncStatusOpcode = this.responseData.readUnsignedByte();
            this.responseData.skipBytes(2);
        }
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("constructor : bytes availabel:" + this.responseData.available());
        }
    }

    public int getStatusByte() {
        Trace.trace("apulhscD", "The Value of Status Byte in ParseResponse ", new Integer(this.statusByte));
        return this.statusByte;
    }

    public boolean isValidResponse(String string) {
        String string2;
        Trace.trace("apulhscT", "HSC Testing", "->isValidResponse in ParseResponse");
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println(" is valid...command entered : " + string);
            System.out.println(" Resource Type : " + this.resourceType);
            System.out.println(" Resource Opcode : " + this.resourceOpcode);
        }
        if ((string2 = (String)this.configValuesPropObj.get(string)) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int n = 0;
            int n2 = 0;
            n = Integer.parseInt(stringTokenizer.nextToken());
            n2 = Integer.parseInt(stringTokenizer.nextToken());
            Trace.trace("apulhscT", "HSC Testing", "<-isValidResponse in ParseResponse");
            return n == this.resourceType && n2 == this.resourceOpcode;
        }
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("ParseResponse Class: Command is not found in Property File");
        }
        return false;
    }

    public boolean isNoErrorStatusResponse() {
        Trace.trace("apulhscD", "The Value of Status Byte in ParseResponse ", new Integer(this.statusByte));
        return this.statusByte == 0;
    }

    public Hashtable getParsedData(String string) throws IOException {
        Trace.trace("apulhscT", "HSC Testing", "->getParsedData");
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("do parse : bytes availabel:" + this.responseData.available());
            System.out.println("** COMMAND:  " + string);
        }
        this.responseData.reset();
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("do parse : bytes availabe*" + this.responseData.available());
        }
        if (this.statusByte > 0 || this.statusByte == 16) {
            if (this.statusByte == 8) {
                this.responseData.skipBytes(8);
            } else {
                this.responseData.skipBytes(5);
            }
        } else if (this.ttyOpcode == 3 || this.ttyOpcode == 4) {
            this.responseData.skipBytes(6);
        } else {
            this.responseData.skipBytes(8);
        }
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("get parsed Data available bytes : " + this.responseData.available());
            System.out.println("resource type:" + this.resourceType);
            System.out.println("resource opcode:" + this.resourceOpcode);
        }
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        hashtable2.put("PAD", new Integer(0));
        hashtable2.put("STRING", new Integer(1));
        hashtable2.put("BYTE", new Integer(2));
        hashtable2.put("SHORT", new Integer(3));
        hashtable2.put("INT", new Integer(4));
        hashtable2.put("FIXED_STRING", new Integer(5));
        hashtable2.put("ALL", new Integer(6));
        hashtable2.put("DATA", new Integer(7));
        hashtable2.put(SLOT_INFORMATION, new Integer(8));
        hashtable2.put("ALL_DRAWER_IDS", new Integer(9));
        hashtable2.put("BYTEH", new Integer(10));
        hashtable2.put("SHORTH", new Integer(11));
        hashtable2.put("BROADCAST_EVENT_FORMATS", new Integer(12));
        hashtable2.put("TWO_STRING_ID_WITH_NULL", new Integer(13));
        hashtable2.put("SKIP_BYTE", new Integer(14));
        hashtable2.put("BYTE_STRING", new Integer(15));
        hashtable2.put(MULTI_LINES_DATA, new Integer(16));
        hashtable2.put(SP_LOG_ENTRY, new Integer(17));
        hashtable2.put("PROCESSOR_AFFINITY_GROUP_INFO", new Integer(18));
        hashtable2.put(ALL_LPAR_DEFINITION_FIELDS, new Integer(19));
        hashtable2.put("MEMORY_PROCESSOR_AFFINITY_GROUP_INFO", new Integer(20));
        hashtable2.put("VERSION_STRING", new Integer(21));
        hashtable2.put("PARAMS_LIST", new Integer(22));
        hashtable2.put(RESOURCE_ELEMENT_IDS, new Integer(23));
        hashtable2.put(LPAR_INFO_LIST, new Integer(24));
        hashtable2.put(SMA_AFFINITY_GROUPS, new Integer(25));
        hashtable2.put(SMA_LINK_INFO, new Integer(26));
        hashtable2.put(DEV_LIST, new Integer(27));
        hashtable2.put("SKIP_60", new Integer(28));
        hashtable2.put("SKIP_BYTE_TYPE1", new Integer(29));
        hashtable2.put("VERSIONS_SUPPORTED", new Integer(30));
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("command-> :" + string);
        }
        String string2 = (String)this.configValuesPropObj.get(string);
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("command-> :" + string2);
        }
        Trace.trace("apulhscD", "The Response Format in ParseResponse", string2);
        if (string2 == null) {
            System.out.println("Debug: command is not found in the text file");
        }
        if (string2 != null) {
            if (GlobalConfig.debugLevel((int)7) > 0) {
                System.out.println("Cmd Format :" + string2);
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            if (GlobalConfig.debugLevel((int)7) > 0) {
                System.out.println("Token : " + stringTokenizer);
            }
            if (string.equals(new String("READ_NOTIFICATION_STATUS")) && this.responseData.available() == 0) {
                hashtable.put(NO_OUTSTANDING_PKTS, new Integer(1));
                return hashtable;
            }
            if (stringTokenizer.countTokens() != 0) {
                int n = 0;
                int n2 = 0;
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println("count Tokens : " + stringTokenizer.countTokens());
                }
                if (this.statusByte == 0 && this.ttyOpcode != 4 && this.ttyOpcode != 3) {
                    n = Integer.parseInt(stringTokenizer.nextToken());
                    n2 = Integer.parseInt(stringTokenizer.nextToken());
                }
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println("ttyStatus : " + this.ttyStatus);
                }
                if (this.ttyOpcode == 3 || this.ttyOpcode == 4 || this.statusByte != 0 || n == this.resourceType && n2 == this.resourceOpcode) {
                    if (GlobalConfig.debugLevel((int)7) > 0) {
                        System.out.println("available bytes {{: " + this.responseData.available());
                    }
                    Object var8_8 = null;
                    int n3 = stringTokenizer.countTokens();
                    int n4 = 0;
                    while (n4 < n3) {
                        Object object;
                        Object object2;
                        Object object3;
                        Object object4;
                        Object object5;
                        Object object6;
                        Object object7;
                        int n5;
                        StringTokenizer stringTokenizer2;
                        Object object8;
                        Object object9;
                        int n6;
                        int n7;
                        int n8;
                        String string3 = stringTokenizer.nextToken().trim();
                        if (GlobalConfig.debugLevel((int)7) > 0) {
                            System.out.println("responseToken : " + string3);
                        }
                        StringTokenizer stringTokenizer3 = new StringTokenizer(string3, "+");
                        String string4 = stringTokenizer3.nextToken();
                        if (GlobalConfig.debugLevel((int)7) > 0) {
                            System.out.println("value key token : " + string4);
                        }
                        Integer n9 = (Integer)hashtable2.get(string4);
                        if (GlobalConfig.debugLevel((int)7) > 0) {
                            System.out.println("switch map value : " + n9);
                        }
                        if (n9 == 8) {
                            Hashtable<Integer, Object> hashtable3 = new Hashtable<Integer, Object>();
                            n8 = (Integer)hashtable.get(LEN_EACH_SLOT_INFO);
                            if (GlobalConfig.debugLevel((int)7) > 0) {
                                System.out.println("********each slot info:" + n8);
                            }
                            n7 = this.responseData.available();
                            n6 = 0;
                            if (n8 == 20) {
                                n6 = n7 / 20;
                            }
                            if (n8 == 24) {
                                n6 = n7 / 24;
                            }
                            int n10 = 0;
                            while (n10 < n6) {
                                object9 = new Hashtable();
                                object8 = null;
                                if (n8 == 20) {
                                    object8 = (String)this.configValuesPropObj.get(SLOT_INFORMATION);
                                }
                                if (n8 == 24) {
                                    object8 = (String)this.configValuesPropObj.get("SLOT_INFORMATION_VER2");
                                }
                                stringTokenizer2 = new StringTokenizer((String)object8, ",");
                                n5 = stringTokenizer2.countTokens();
                                int n11 = 0;
                                if (n8 == 20) {
                                    n11 = 20;
                                }
                                if (n8 == 24) {
                                    n11 = 24;
                                }
                                object7 = new byte[n11];
                                this.responseData.read((byte[])object7, 0, n11);
                                object6 = new ByteArrayInputStream((byte[])object7);
                                object5 = new DataInputStream((InputStream)object6);
                                int n12 = 0;
                                while (n12 < n5) {
                                    object4 = stringTokenizer2.nextToken().trim();
                                    object3 = new StringTokenizer((String)object4, "+");
                                    object2 = ((StringTokenizer)object3).nextToken();
                                    if (GlobalConfig.debugLevel((int)7) > 0) {
                                        System.out.println("**slot value key token : " + (String)object2);
                                    }
                                    object = (Integer)hashtable2.get(object2);
                                    if (GlobalConfig.debugLevel((int)7) > 0) {
                                        System.out.println(" ******************** map values : " + object);
                                    }
                                    this.parseBasicTypes((DataInputStream)object5, (Hashtable)object9, (Integer)object, (StringTokenizer)object3);
                                    Integer n13 = (Integer)((Hashtable)object9).get(SLOT_NO);
                                    if (GlobalConfig.debugLevel((int)7) > 0) {
                                        System.out.println("********Slot Number:" + n13);
                                    }
                                    ++n12;
                                }
                                hashtable3.put(new Integer(n10), object9);
                                object4 = (Integer)((Hashtable)object9).get(SLOT_NO);
                                ++n10;
                            }
                            hashtable.put(SLOT_INFORMATION, hashtable3);
                            if (GlobalConfig.debugLevel((int)7) > 0) {
                                System.out.println("obj.putSLOT_INFORMATION");
                            }
                        }
                        if (n9 == 12) {
                            this.getParsedParameterList(hashtable, hashtable2);
                        }
                        if (n9 == 9) {
                            int n14 = this.responseData.available();
                            n8 = (Integer)hashtable.get(NUM_IO_DRAWERS);
                            String[] stringArray = new String[n8];
                            n6 = 0;
                            while (n6 < n8) {
                                String string5 = (String)this.configValuesPropObj.get("ALL_DRAWER_IDS");
                                int n15 = this.responseData.readUnsignedByte();
                                if (GlobalConfig.debugLevel((int)7) > 0) {
                                    System.out.println(" the Length of the Drawer ID is .." + n15);
                                }
                                object8 = new StringTokenizer(string5, ",");
                                int n16 = ((StringTokenizer)object8).countTokens();
                                byte[] byArray = new byte[n15];
                                this.responseData.read(byArray, 0, n15);
                                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                                object7 = new DataInputStream(byteArrayInputStream);
                                int n17 = 0;
                                while (n17 < n16) {
                                    object5 = new Hashtable();
                                    String string6 = ((StringTokenizer)object8).nextToken().trim();
                                    object4 = new StringTokenizer(string6, "+");
                                    object3 = ((StringTokenizer)object4).nextToken();
                                    object2 = (Integer)hashtable2.get(object3);
                                    this.parseBasicTypes((DataInputStream)object7, (Hashtable)object5, (Integer)object2, (StringTokenizer)object4);
                                    if (GlobalConfig.debugLevel((int)7) > 0) {
                                        System.out.println("\n Drawer ****idobj = " + object5);
                                    }
                                    object = (String)((Hashtable)object5).get(DRAWER_ID);
                                    if ((Integer)object2 == 13) {
                                        stringArray[n6] = object;
                                        if (GlobalConfig.debugLevel((int)7) > 0) {
                                            System.out.println("\n Drawer top level = " + stringArray[n6]);
                                        }
                                    }
                                    ++n17;
                                }
                                ++n6;
                            }
                            hashtable.put(DRAWER_IDS, stringArray);
                        }
                        if (n9 == 26 || n9 == 24) {
                            int n18;
                            boolean bl = n9 == 26;
                            System.out.println("Link flag is: " + bl + "\n");
                            Vector vector = new Vector(0);
                            n7 = this.responseData.available();
                            if (bl) {
                                n18 = 72;
                                n6 = n7 / 72;
                            } else {
                                n18 = 8;
                                n6 = n7 / 8;
                            }
                            int n19 = 0;
                            while (n19 < n6) {
                                object9 = bl ? (String)this.configValuesPropObj.get(SMA_LINK_INFO) : (String)this.configValuesPropObj.get(LPAR_INFO_LIST);
                                stringTokenizer2 = new StringTokenizer((String)object9, ",");
                                n5 = stringTokenizer2.countTokens();
                                Hashtable hashtable4 = new Hashtable();
                                object7 = new byte[n18];
                                this.responseData.read((byte[])object7, 0, n18);
                                object6 = new ByteArrayInputStream((byte[])object7);
                                object5 = new DataInputStream((InputStream)object6);
                                int n20 = 0;
                                while (n20 < n5) {
                                    object4 = stringTokenizer2.nextToken().trim();
                                    object3 = new StringTokenizer((String)object4, "+");
                                    object2 = ((StringTokenizer)object3).nextToken();
                                    object = (Integer)hashtable2.get(object2);
                                    this.parseBasicTypes((DataInputStream)object5, hashtable4, (Integer)object, (StringTokenizer)object3);
                                    ++n20;
                                }
                                vector.addElement(hashtable4);
                                ++n19;
                            }
                            if (bl) {
                                hashtable.put(SMA_LINK_INFO, vector);
                            } else {
                                hashtable.put(LPAR_INFO_LIST, vector);
                            }
                        }
                        if (n9 == 25) {
                            int n21 = (Integer)hashtable.get(NUM_AFFINITY_GROUPS);
                            Vector vector = new Vector(0);
                            n7 = 0;
                            while (n7 < n21) {
                                Hashtable hashtable5 = new Hashtable();
                                String string7 = (String)this.configValuesPropObj.get(SMA_AFFINITY_GROUPS);
                                object9 = new StringTokenizer(string7, ",");
                                int n22 = ((StringTokenizer)object9).countTokens();
                                int n23 = 0;
                                while (n23 < n22) {
                                    String string8 = ((StringTokenizer)object9).nextToken().trim();
                                    StringTokenizer stringTokenizer4 = new StringTokenizer(string8, "+");
                                    object7 = stringTokenizer4.nextToken().trim();
                                    object6 = (Integer)hashtable2.get(object7);
                                    this.parseBasicTypes(this.responseData, hashtable5, (Integer)object6, stringTokenizer4);
                                    ++n23;
                                }
                                vector.addElement(hashtable5);
                                ++n7;
                            }
                            hashtable.put(SMA_AFFINITY_GROUPS, vector);
                        }
                        if (n9 == 30) {
                            int n24 = (Integer)hashtable.get(NUMBER_OF_VERSIONS_SUPPORTED);
                            Vector vector = new Vector(n24);
                            String string9 = (String)this.configValuesPropObj.get("VERSIONS_SUPPORTED");
                            Hashtable hashtable6 = null;
                            StringTokenizer stringTokenizer5 = null;
                            object9 = null;
                            int n25 = 0;
                            while (n25 < n24) {
                                hashtable6 = new Hashtable();
                                stringTokenizer5 = new StringTokenizer(string9, "+");
                                object9 = (Integer)hashtable2.get(stringTokenizer5.nextToken().trim());
                                this.parseBasicTypes(this.responseData, hashtable6, (Integer)object9, stringTokenizer5);
                                vector.addElement(hashtable6);
                                this.responseData.reset();
                                ++n25;
                            }
                            hashtable.put(VERSION_LIST, vector);
                        }
                        this.parseBasicTypes(this.responseData, hashtable, n9, stringTokenizer3);
                        ++n4;
                    }
                }
            }
        }
        hashtable.put(ERROR_TYPE, new Integer(0));
        Trace.trace("apulhscT", "HSC Testing", "<-getParsedData");
        return hashtable;
    }

    public Hashtable getAckData() throws IOException {
        Trace.trace("apulhscT", "HSC Testing", "->getAckData");
        Hashtable hashtable = new Hashtable();
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("function:getAckData:statusByte=" + this.statusByte);
        }
        switch (this.statusByte) {
            case 1: {
                hashtable = this.getParsedData("INVALID_COMMAND");
                break;
            }
            case 2: {
                hashtable = this.getParsedData("NO_SUCH_OBJECT");
                break;
            }
            case 3: {
                hashtable = this.getParsedData("INVALID_DATA");
                break;
            }
            case 4: {
                hashtable = this.getParsedData("INVALID_COMMAND_SEQUENCE");
                break;
            }
            case 6: {
                hashtable = this.getParsedData("COMMAND_FAILED");
                break;
            }
            case 7: {
                hashtable = this.getParsedData("COMMAND_TIME_OUT");
                break;
            }
            case 255: {
                hashtable = this.getParsedData("COMMAND_BUSY");
                break;
            }
            case 9: {
                hashtable = this.getParsedData("TTY_BUFFER_FULL");
                break;
            }
            case 191: {
                hashtable = this.getParsedData("RESERVED");
                break;
            }
        }
        hashtable.put(ERROR_TYPE, new Integer(this.statusByte));
        Trace.trace("apulhscT", "HSC Testing", "<-getAckData in ParseResponse");
        return hashtable;
    }

    public Hashtable getAsyncData() throws IOException {
        Trace.trace("apulhscT", "HSC Testing", "->getAsyncData in ParseResponse");
        Hashtable hashtable = null;
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("function:getNoficationDataa:statusByte=" + this.statusByte);
            System.out.println("function:getNoficationDataa:asyncStatusOpcode=" + this.asyncStatusOpcode);
        }
        if (this.statusByte == 8) {
            switch (this.asyncStatusOpcode) {
                case 2: {
                    hashtable = new Hashtable();
                    break;
                }
                case 5: {
                    this.responseData.skipBytes(2);
                    int n = this.responseData.readUnsignedByte();
                    if (GlobalConfig.debugLevel((int)7) > 0) {
                        System.out.println(" ++event Type : " + n);
                        System.out.println("get async Data available bytes : " + this.responseData.available());
                    }
                    switch (n) {
                        case 0: {
                            hashtable = this.getParsedData("NOTIFY_EVT_BROADCAST");
                            break;
                        }
                        case 1: {
                            hashtable = this.getParsedData("NOTIFY_EVT_LPAR_STATE_CHANGE");
                            break;
                        }
                        case 2: {
                            hashtable = this.getParsedData("NOTIFY_EVT_CEC_STATE_CHANGE");
                            break;
                        }
                        case 3: {
                            if (this.release_version == 1000 || this.release_version == 2000) {
                                hashtable = this.getParsedData("NOTIFY_EVT_HARDWARE_CHANGE");
                                break;
                            }
                            hashtable = this.getParsedData("NOTIFY_EVT_PARTITION_PROC_CONFIGURATION_CHANGE");
                            break;
                        }
                        case 5: {
                            hashtable = this.getParsedData("NOTIFY_EVT_PARTITION_MEM_CONFIGURATION_CHANGE");
                            break;
                        }
                        case 6: {
                            hashtable = this.getParsedData("NOTIFY_EVT_PARTITION_IO_CONFIGURATION_CHANGE");
                            break;
                        }
                        case 4: {
                            hashtable = this.getParsedData("NOTIFY_EVT_HSC_INFO_CLEAR");
                            break;
                        }
                        case 7: {
                            hashtable = this.getParsedData("NOTIFY_EVT_CUOD_CAPACITY_EVENT");
                            break;
                        }
                        case 11: {
                            hashtable = this.getParsedData("NOTIFY_EVT_DISPLAY_MESSAGE_EVENT");
                            break;
                        }
                        case 12: {
                            hashtable = this.getParsedData("NOTIFY_EVT_ONOFF_CAPACITY_EVENT");
                        }
                    }
                    break;
                }
                case 6: {
                    hashtable = this.getParsedData("HANDLER_EVENT");
                    hashtable.put("ASYNC_STATUS", new Integer(6));
                    break;
                }
            }
            if (GlobalConfig.debugLevel((int)7) > 0) {
                System.out.println("**debug : async data ");
            }
            hashtable.put(STATUS_BYTE, new Integer(this.statusByte));
            hashtable.put(ASYNC_STATUS_OPCODE, new Integer(this.asyncStatusOpcode));
        }
        if (this.statusByte == 16) {
            hashtable = this.getParsedData("TTY_UPSTREAM_DATA");
            hashtable.put(STATUS_BYTE, new Integer(this.statusByte));
        }
        Trace.trace("apulhscT", "HSC Testing", "<-getAsyncData in ParseResponse");
        return hashtable;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void getParsedParameterList(Hashtable hashtable, Hashtable hashtable2) throws IOException {
        Trace.trace("apulhscT", "HSC Testing", "->getParsedParameterList in ParseResponse");
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("\n getParsedParameterList method:");
        }
        int n = this.responseData.available();
        byte[] byArray = new byte[32];
        int n2 = 0;
        while (n2 < 32) {
            byte by = this.responseData.readByte();
            if (by == 0) {
                byArray[n2] = by;
                break;
            }
            byArray[n2] = by;
            ++n2;
        }
        String string = new String(byArray).trim();
        hashtable.put(new String(OWNER), string);
        int n3 = this.responseData.readUnsignedShort();
        int n4 = this.responseData.readUnsignedShort();
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("broadcast_evt=" + n4);
            System.out.println("resource_evt=" + n3);
        }
        hashtable.put(new String(RESOURCE), new Integer(n3));
        hashtable.put(new String(BROADCAST_EVENT), new Integer(n4));
        String string2 = new String();
        switch (n3) {
            case 1: {
                switch (n4) {
                    case 1: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_CEC_VIRTUAL_TTY");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_CEC_VIRTUAL_TTY");
                        break;
                    }
                    case 2: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_CEC_SET_POLICY");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_CEC_SET_POLICY");
                        break;
                    }
                    case 4: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_CEC_SET_NAME");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_CEC_SET_NAME");
                        break;
                    }
                }
                break;
            }
            case 2: {
                switch (n4) {
                    case 1: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_CREATE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_CREATE");
                        break;
                    }
                    case 2: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_DELETE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_DELETE");
                        break;
                    }
                    case 4: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_SET_NAME");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_SET_NAME");
                        break;
                    }
                    case 8: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_VIRTUAL_TTY");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_VIRTUAL_TTY");
                        break;
                    }
                    case 16: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_ACTIVATE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_ACTIVATE");
                        break;
                    }
                    case 32: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_RESOURCE_ASSIGNMENT");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_RESOURCE_ASSIGNMENT");
                        break;
                    }
                }
                break;
            }
            case 4: {
                switch (n4) {
                    case 1: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_PROFILE_CREATE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_PROFILE_CREATE");
                        break;
                    }
                    case 2: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_PROFILE_DELETE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_PROFILE_DELETE");
                        break;
                    }
                    case 4: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_PROFILE_MODIFY");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_PROFILE_MODIFY");
                        break;
                    }
                    case 8: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_LPAR_PROFILE_SET_DEFAULT_PROFILE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_LPAR_PROFILE_SET_DEFAULT_PROFILE");
                        break;
                    }
                }
                break;
            }
            case 8: {
                switch (n4) {
                    case 1: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_SYSTEM_PROFILE_CREATE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_SYSTEM_PROFILE_CREATE");
                        break;
                    }
                    case 2: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_SYSTEM_PROFILE_DELETE");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_SYSTEM_PROFILE_DELETE");
                        break;
                    }
                    case 4: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_SYSTEM_PROFILE_ADD_LPAR");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_SYSTEM_PROFILE_ADD_LPAR");
                        break;
                    }
                    case 8: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_SYSTEM_PROFILE_REMOVE_LPAR");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_SYSTEM_PROFILE_REMOVE_LP");
                        break;
                    }
                    case 16: {
                        string2 = (String)this.configValuesPropObj.get("BROADCAST_EVENT_SYSTEM_PROFILE_MODIFY_LPAR");
                        if (GlobalConfig.debugLevel((int)7) <= 0) break;
                        System.out.println("BROADCAST_EVENT_SYSTEM_PROFILE_MODIFY_LPAR");
                    }
                }
                break;
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        int n5 = stringTokenizer.countTokens();
        int n6 = 0;
        while (n6 < n5) {
            String string3 = stringTokenizer.nextToken().trim();
            if (GlobalConfig.debugLevel((int)7) > 0) {
                System.out.println("evtToken : " + string3);
            }
            StringTokenizer stringTokenizer2 = new StringTokenizer(string3, "+");
            String string4 = stringTokenizer2.nextToken();
            Integer n7 = (Integer)hashtable2.get(string4);
            if (GlobalConfig.debugLevel((int)7) > 0) {
                System.out.println("available bytes " + this.responseData.available());
            }
            this.parseBasicTypes(this.responseData, hashtable, n7, stringTokenizer2);
            ++n6;
        }
        Trace.trace("apulhscT", "HSC Testing", "<-getParsedParameterList in ParseResponse");
    }

    public Hashtable getVirtualTTYData() throws IOException {
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println(".....function:getVirtualTTYData:statusByte");
        }
        Trace.trace("apulhscT", "HSC Testing", "->getVirtualTTYData in ParseResponse");
        Hashtable hashtable = null;
        this.responseData.reset();
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("function:getVirtualTTYData:available Bytes =" + this.responseData.available());
        }
        this.responseData.skipBytes(5);
        this.resourceType = -1;
        this.resourceOpcode = -1;
        this.ttyOpcode = this.responseData.readUnsignedByte();
        if (GlobalConfig.debugLevel((int)7) > 0) {
            System.out.println("function:getVirtualTTYData:available ttyStatus =" + this.ttyStatus);
            System.out.println("function:getVirtualTTYData:available ttyOpcode =" + this.ttyOpcode);
        }
        switch (this.ttyOpcode) {
            case 3: {
                hashtable = this.getParsedData("OPEN_VIRTUAL_TTY");
                break;
            }
            case 4: {
                hashtable = this.getParsedData("CLOSE_VIRTUAL_TTY");
                break;
            }
        }
        if (hashtable == null) {
            System.out.println("object is null");
        }
        System.out.println("TTY_OPCODE " + this.ttyOpcode);
        hashtable.put(TTY_OPCODE, new Integer(this.ttyOpcode));
        Trace.trace("apulhscT", "HSC Testing", "<-getVirtualTTYData in ParseResponse");
        return hashtable;
    }

    private void parseBasicTypes(DataInputStream dataInputStream, Hashtable hashtable, Integer n, StringTokenizer stringTokenizer) throws IOException {
        Trace.trace("apulhscT", "HSC Testing", "->parseBasicTypes in ParseResponse");
        String string = null;
        block0 : switch (n) {
            case 0: {
                dataInputStream.skipBytes(1);
                System.out.println("\nPAD");
                break;
            }
            case 1: {
                int n2 = dataInputStream.available();
                byte[] byArray = new byte[32];
                int n3 = 0;
                while (n3 < 32) {
                    byte by = dataInputStream.readByte();
                    if (by == 0) {
                        byArray[n3] = by;
                        break;
                    }
                    byArray[n3] = by;
                    ++n3;
                }
                String string2 = new String(byArray).trim();
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println("the STRING = " + string2);
                }
                string = stringTokenizer.nextToken();
                hashtable.put(string, string2);
                break;
            }
            case 2: {
                int n4 = dataInputStream.readUnsignedByte();
                string = stringTokenizer.nextToken();
                hashtable.put(string, new Integer(n4));
                if (GlobalConfig.debugLevel((int)7) <= 0) break;
                System.out.println(" ####key,value : " + string + " " + n4);
                break;
            }
            case 3: {
                int n5 = dataInputStream.readUnsignedShort();
                string = stringTokenizer.nextToken();
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println(" key : " + string);
                }
                hashtable.put(string, new Integer(n5));
                if (GlobalConfig.debugLevel((int)7) <= 0) break;
                System.out.println(" short value : " + n5);
                break;
            }
            case 4: {
                long l = 0L;
                long l2 = 255L;
                int n6 = dataInputStream.readUnsignedByte();
                int n7 = dataInputStream.readUnsignedByte();
                int n8 = dataInputStream.readUnsignedByte();
                int n9 = dataInputStream.readUnsignedByte();
                l = ((long)n6 & l2) << 24 | ((long)n7 & l2) << 16 | ((long)n8 & l2) << 8 | (long)n9 & l2;
                string = stringTokenizer.nextToken();
                hashtable.put(string, new Long(l));
                break;
            }
            case 5: {
                int n10 = Integer.parseInt(stringTokenizer.nextToken());
                byte[] byArray = new byte[n10];
                dataInputStream.read(byArray, 0, n10);
                String string3 = new String(byArray);
                string = stringTokenizer.nextToken();
                hashtable.put(string, string3);
                if (GlobalConfig.debugLevel((int)7) <= 0) break;
                System.out.println("Fixed String: " + string3);
                break;
            }
            case 6: {
                int n11 = this.responseData.available();
                Vector<Integer> vector = new Vector<Integer>();
                int n12 = 0;
                while (n12 < n11) {
                    int n13 = this.responseData.readUnsignedByte();
                    vector.add(new Integer(n13));
                    ++n12;
                }
                string = stringTokenizer.nextToken();
                hashtable.put(string, vector);
                break;
            }
            case 7: {
                byte[] byArray = new byte[dataInputStream.available()];
                dataInputStream.read(byArray);
                string = stringTokenizer.nextToken();
                hashtable.put(string, byArray);
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                int n14 = dataInputStream.readUnsignedByte();
                String string4 = Integer.toHexString(n14);
                n14 = Integer.valueOf(string4, 10);
                string = stringTokenizer.nextToken();
                hashtable.put(string, new Integer(n14));
                if (GlobalConfig.debugLevel((int)7) <= 0) break;
                System.out.println(" ####key,value : " + string + " " + n14);
                break;
            }
            case 11: {
                int n15 = dataInputStream.readUnsignedShort();
                String string5 = Integer.toHexString(n15);
                n15 = Integer.valueOf(string5, 10);
                string = stringTokenizer.nextToken();
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println(" key : " + string);
                }
                hashtable.put(string, new Integer(n15));
                if (GlobalConfig.debugLevel((int)7) <= 0) break;
                System.out.println(" short value : " + n15);
                break;
            }
            case 13: {
                String string6;
                int n16;
                if (hashtable.containsKey(IO_DRAWER_CHANGE) && (n16 = ((Integer)hashtable.get(IO_DRAWER_CHANGE)).intValue()) == 0 || hashtable.containsKey(RESOURCE_ELEMENT_IDS) & hashtable.containsKey(RESOURCE_TYPE) && (n16 = ((Integer)hashtable.get(RESOURCE_TYPE)).intValue()) != 2) break;
                byte[] byArray = new byte[60];
                int n17 = 0;
                boolean bl = true;
                while (n17 < 60) {
                    byte by = dataInputStream.readByte();
                    if (GlobalConfig.debugLevel((int)7) > 0) {
                        System.out.println(" the counter is ,," + n17 + " the data " + by);
                    }
                    if (by == 0) {
                        if (!bl) break;
                        string6 = "*";
                        byte[] byArray2 = string6.getBytes();
                        byArray[n17] = byArray2[0];
                        if (GlobalConfig.debugLevel((int)7) > 0) {
                            System.out.println(" in the first false..");
                        }
                        bl = false;
                    } else {
                        byArray[n17] = by;
                    }
                    ++n17;
                }
                string6 = new String(byArray).trim();
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println("the TWO STRING ID  = " + string6);
                }
                string = stringTokenizer.nextToken();
                hashtable.put(string, string6);
                break;
            }
            case 14: {
                int n18 = dataInputStream.readUnsignedByte();
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println(" inside of the SKIP.." + n18);
                }
                dataInputStream.skipBytes(n18);
                string = stringTokenizer.nextToken();
                hashtable.put(string, new Integer(n18));
                if (GlobalConfig.debugLevel((int)7) <= 0) break;
                System.out.println(" ####key,value : " + string + " " + n18);
                break;
            }
            case 15: {
                int n19 = dataInputStream.readUnsignedByte();
                String string7 = Integer.toString(n19);
                n19 = dataInputStream.readUnsignedByte();
                string7 = string7 + Integer.toString(n19);
                n19 = dataInputStream.readUnsignedByte();
                string7 = string7 + Integer.toString(n19);
                string = stringTokenizer.nextToken();
                hashtable.put(string, string7);
                System.out.println(" the PCI CLASS CODE IS .." + string7);
                System.out.println(" ####key,value : " + string + " " + n19);
                break;
            }
            case 16: {
                int n20 = (Integer)hashtable.get(OP_PANEL_NLINES);
                int n21 = (Integer)hashtable.get(OP_PANEL_WIDTH);
                Vector<String> vector = new Vector<String>();
                int n22 = 0;
                while (n22 < n20) {
                    byte[] byArray = new byte[n21];
                    dataInputStream.read(byArray, 0, n21);
                    String string8 = new String(byArray);
                    vector.addElement(string8);
                    ++n22;
                }
                string = stringTokenizer.nextToken();
                hashtable.put(string, vector);
                System.out.println(" ####key,value : " + string + " " + vector);
                break;
            }
            case 17: {
                Vector<String> vector = new Vector<String>();
                int n23 = 0;
                while (n23 < dataInputStream.available()) {
                    String string9;
                    int n24 = dataInputStream.readUnsignedByte();
                    Integer n25 = new Integer(n24);
                    String string10 = n25.toString();
                    String string11 = new String("");
                    switch (string10.length()) {
                        case 1: {
                            string11 = string11.concat("00").concat(string10);
                            break;
                        }
                        case 2: {
                            string11 = string11.concat("0").concat(string10);
                            break;
                        }
                        case 3: {
                            string11 = string10;
                        }
                    }
                    if (n24 == 64) {
                        byte by = dataInputStream.readByte();
                        n25 = new Integer(by);
                        string10 = n25.toString();
                        switch (string10.length()) {
                            case 1: {
                                string11 = string11.concat("00").concat(string10);
                                break;
                            }
                            case 2: {
                                string11 = string11.concat("0").concat(string10);
                                break;
                            }
                            case 3: {
                                string11 = string10;
                            }
                        }
                        byte by2 = dataInputStream.readByte();
                        n25 = new Integer(by2);
                        string10 = n25.toString();
                        switch (string10.length()) {
                            case 1: {
                                string11 = string11.concat("00").concat(string10);
                                break;
                            }
                            case 2: {
                                string11 = string11.concat("0").concat(string10);
                                break;
                            }
                            case 3: {
                                string11 = string10;
                            }
                        }
                        byte[] byArray = new byte[by * by2];
                        dataInputStream.read(byArray, 0, by * by2);
                        string9 = new String(byArray).trim();
                    } else {
                        byte[] byArray = new byte[500];
                        int n26 = 0;
                        while (n26 < 500) {
                            byte by = dataInputStream.readByte();
                            if (by == 0) {
                                byArray[n26] = by;
                                break;
                            }
                            byArray[n26] = by;
                            ++n26;
                        }
                        string9 = new String(byArray).trim();
                    }
                    string11 = string11 + string9;
                    vector.addElement(string11);
                    ++n23;
                }
                string = stringTokenizer.nextToken();
                hashtable.put(string, vector);
                System.out.println(" ####key,value : " + string + " " + vector);
                break;
            }
            case 18: {
                int n27 = (Integer)hashtable.get(NUM_GROUPS);
                System.out.println(" numOfgroups = " + n27);
                Vector vector = new Vector();
                int n28 = 0;
                while (n28 < n27) {
                    int n29;
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                    int n30 = this.responseData.readUnsignedByte();
                    this.responseData.skipBytes(n30);
                    this.responseData.skipBytes(2);
                    long l = 0L;
                    long l3 = 255L;
                    int n31 = dataInputStream.readUnsignedByte();
                    int n32 = dataInputStream.readUnsignedByte();
                    int n33 = dataInputStream.readUnsignedByte();
                    int n34 = dataInputStream.readUnsignedByte();
                    l = ((long)n31 & l3) << 24 | ((long)n32 & l3) << 16 | ((long)n33 & l3) << 8 | (long)n34 & l3;
                    hashtable2.put(TOTAL_MEMORY, new Long(l));
                    int n35 = dataInputStream.readUnsignedByte();
                    hashtable2.put(NUM_PROCESSORS, new Integer(n35));
                    Vector<Integer> vector2 = new Vector<Integer>();
                    int n36 = 0;
                    while (n36 < n35) {
                        n29 = dataInputStream.readUnsignedByte();
                        vector2.addElement(new Integer(n29));
                        ++n36;
                    }
                    hashtable2.put(PROC_GROUP_LIST, vector2);
                    n29 = dataInputStream.readUnsignedByte();
                    byte[] byArray = new byte[n29];
                    dataInputStream.read(byArray, 0, n29);
                    String string12 = new String(byArray);
                    hashtable2.put(PROC_GROUP_LOCATION, string12);
                    vector.addElement(hashtable2);
                    ++n28;
                }
                hashtable.put(GROUP_LIST, vector);
                break;
            }
            case 19: {
                int n37 = (Integer)hashtable.get(NUM_LPAR_SLOTS);
                Vector vector = new Vector();
                int n38 = 0;
                while (n38 < n37) {
                    Hashtable<String, Integer> hashtable3 = new Hashtable<String, Integer>();
                    int n39 = dataInputStream.readUnsignedByte();
                    hashtable3.put(SLOT_DEFINITION, new Integer(n39));
                    int n40 = dataInputStream.readUnsignedByte();
                    hashtable3.put(TYPE_VALUE, new Integer(n40));
                    int n41 = dataInputStream.readUnsignedByte();
                    hashtable3.put(RMO_TYPE, new Integer(n41));
                    vector.addElement(hashtable3);
                    ++n38;
                }
                hashtable.put(ALL_LPAR_DEFINITION_FIELDS, vector);
                break;
            }
            case 20: {
                int n42 = (Integer)hashtable.get(NUM_GROUPS);
                System.out.println(" numOfgroups = " + n42);
                Vector vector = new Vector();
                int n43 = 0;
                while (n43 < n42) {
                    Hashtable<String, Object> hashtable4 = new Hashtable<String, Object>();
                    int n44 = this.responseData.readUnsignedByte();
                    this.responseData.skipBytes(n44);
                    this.responseData.skipBytes(2);
                    long l = 0L;
                    long l4 = 255L;
                    int n45 = dataInputStream.readUnsignedByte();
                    int n46 = dataInputStream.readUnsignedByte();
                    int n47 = dataInputStream.readUnsignedByte();
                    int n48 = dataInputStream.readUnsignedByte();
                    l = ((long)n45 & l4) << 24 | ((long)n46 & l4) << 16 | ((long)n47 & l4) << 8 | (long)n48 & l4;
                    hashtable4.put(TOTAL_MEMORY, new Long(l));
                    l = 0L;
                    l4 = 255L;
                    n45 = dataInputStream.readUnsignedByte();
                    n46 = dataInputStream.readUnsignedByte();
                    n47 = dataInputStream.readUnsignedByte();
                    n48 = dataInputStream.readUnsignedByte();
                    l = ((long)n45 & l4) << 24 | ((long)n46 & l4) << 16 | ((long)n47 & l4) << 8 | (long)n48 & l4;
                    hashtable4.put(FAILED_MEMORY, new Long(l));
                    l = 0L;
                    l4 = 255L;
                    n45 = dataInputStream.readUnsignedByte();
                    n46 = dataInputStream.readUnsignedByte();
                    n47 = dataInputStream.readUnsignedByte();
                    n48 = dataInputStream.readUnsignedByte();
                    l = ((long)n45 & l4) << 24 | ((long)n46 & l4) << 16 | ((long)n47 & l4) << 8 | (long)n48 & l4;
                    hashtable4.put(TOT_AVAILABLE_MEMORY, new Long(l));
                    int n49 = dataInputStream.readUnsignedByte();
                    byte[] byArray = new byte[n49];
                    dataInputStream.read(byArray, 0, n49);
                    String string13 = new String(byArray);
                    hashtable4.put(PROC_GROUP_LOCATION, string13);
                    n49 = dataInputStream.readUnsignedByte();
                    byArray = new byte[n49];
                    dataInputStream.read(byArray, 0, n49);
                    String string14 = new String(byArray);
                    hashtable4.put(MEM_GROUP_LOCATION, string13);
                    vector.addElement(hashtable4);
                    ++n43;
                }
                hashtable.put(GROUP_LIST, vector);
                break;
            }
            case 21: {
                byte[] byArray = new byte[32];
                boolean bl = false;
                dataInputStream.mark(2);
                byte by = dataInputStream.readByte();
                hashtable.put(FORMAT_TYPE, new Byte(by));
                switch (by) {
                    case 86: {
                        dataInputStream.reset();
                        int n50 = 0;
                        while (n50 < 32) {
                            int n51 = dataInputStream.available();
                            if (n51 == 0) {
                                if (GlobalConfig.debugLevel((int)7) > 0) {
                                    System.out.println("parsing versio string to eof");
                                }
                                bl = true;
                                break;
                            }
                            by = dataInputStream.readByte();
                            if (by == 0) {
                                byArray[n50] = by;
                                break;
                            }
                            byArray[n50] = by;
                            ++n50;
                        }
                        String string15 = new String(byArray).trim();
                        if (!bl || bl && string15.equals("V1.0")) {
                            string = stringTokenizer.nextToken();
                            hashtable.put(string, string15);
                        }
                        if (!bl || string15.equals("V1.0")) break block0;
                        throw new EOFException();
                    }
                    case 78: {
                        int n52 = dataInputStream.available();
                        int n53 = 0;
                        while (n53 < 32) {
                            by = dataInputStream.readByte();
                            if (by == 0) {
                                byArray[n53] = by;
                                break;
                            }
                            byArray[n53] = by;
                            ++n53;
                        }
                        String string16 = new String(byArray).trim();
                        string = stringTokenizer.nextToken();
                        hashtable.put(string, string16);
                        if (dataInputStream.available() == 0) break block0;
                        dataInputStream.mark(2);
                        int n54 = dataInputStream.readUnsignedByte();
                        hashtable.put(NODE_TYPE, new Integer(n54));
                        break block0;
                    }
                }
                int n55 = dataInputStream.available();
                String string17 = "";
                int n56 = 0;
                while (n56 < n55) {
                    int n57 = dataInputStream.readUnsignedByte();
                    String string18 = Integer.toHexString(n57);
                    string17 = string17 + string18;
                    ++n56;
                }
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println("version = " + string17);
                }
                String string19 = new String(string17).trim();
                string = stringTokenizer.nextToken();
                hashtable.put(string, string19);
                break;
            }
            case 22: {
                int n58 = (Integer)hashtable.get(NUM_PARAMS);
                Vector<String> vector = new Vector<String>();
                int n59 = 0;
                while (n59 < n58) {
                    byte[] byArray = new byte[256];
                    int n60 = 0;
                    while (n60 < 256) {
                        byte by = dataInputStream.readByte();
                        if (by == 0) {
                            byArray[n60] = by;
                            break;
                        }
                        byArray[n60] = by;
                        ++n60;
                    }
                    String string20 = new String(byArray).trim();
                    if (GlobalConfig.debugLevel((int)7) > 0) {
                        System.out.println("Parameter String = " + string20);
                    }
                    vector.addElement(string20);
                    ++n59;
                }
                string = stringTokenizer.nextToken();
                hashtable.put(string, vector);
                break;
            }
            case 23: {
                int n61 = (Integer)hashtable.get(NUM_RESOURCES);
                Vector<Integer> vector = new Vector<Integer>();
                int n62 = 0;
                while (n62 < n61) {
                    int n63 = this.responseData.readUnsignedByte();
                    vector.add(new Integer(n63));
                    ++n62;
                }
                hashtable.put(RESOURCE_ELEMENT_IDS, vector);
                break;
            }
            case 27: {
                int n64 = (Integer)hashtable.get(NUM_OF_ADAPTERS);
                Vector<Long> vector = new Vector<Long>(0);
                int n65 = 0;
                while (n65 < n64) {
                    long l = 0L;
                    long l5 = 255L;
                    int n66 = dataInputStream.readUnsignedByte();
                    int n67 = dataInputStream.readUnsignedByte();
                    int n68 = dataInputStream.readUnsignedByte();
                    int n69 = dataInputStream.readUnsignedByte();
                    l = ((long)n66 & l5) << 24 | ((long)n67 & l5) << 16 | ((long)n68 & l5) << 8 | (long)n69 & l5;
                    vector.addElement(new Long(l));
                    ++n65;
                }
                hashtable.put(DEV_LIST, vector);
                break;
            }
            case 28: {
                dataInputStream.skipBytes(60);
                stringTokenizer.nextToken();
                break;
            }
            case 29: {
                int n70 = dataInputStream.readUnsignedByte();
                if (GlobalConfig.debugLevel((int)7) > 0) {
                    System.out.println(" inside of the SKIP.." + (n70 - 1));
                }
                dataInputStream.skipBytes(n70 - 1);
                string = stringTokenizer.nextToken();
                hashtable.put(string, new Integer(n70));
                if (GlobalConfig.debugLevel((int)7) <= 0) break;
                System.out.println(" ####key,value : " + string + " " + (n70 - 1));
                break;
            }
        }
        Trace.trace("apulhscT", "HSC Testing", "->parseBasicTypes in ParseResponse");
    }

    public void finalize() {
        try {
            if (this.responseData != null) {
                this.responseData.close();
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static {
        configValuesPropObj2 = new Properties();
        configValuesPropObj3 = new Properties();
        System.out.println(" inside of the static in parse response...");
        File file = null;
        File file2 = null;
        FileInputStream fileInputStream = null;
        FileInputStream fileInputStream2 = null;
        try {
            file = new File("/opt/hsc/data/HSCResponsePropFile");
            fileInputStream = new FileInputStream(file);
            file2 = new File("/opt/hsc/data/HSCResponsePropFile3");
            fileInputStream2 = new FileInputStream(file2);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String string = " The Properties File HSCResponsePropFile is not available";
            System.out.println("Exception:" + string);
        }
        try {
            configValuesPropObj2.load(fileInputStream);
            fileInputStream.close();
            configValuesPropObj3.load(fileInputStream2);
            fileInputStream2.close();
        }
        catch (IOException iOException) {
            System.out.println("Exception : " + iOException);
        }
    }
}

